The original phrase, "Make it work, make it right, make it fast," is a classic software development mantra, often attributed to Kent Beck (though variations exist). It describes a pragmatic approach to development.

Let's break down how DevOps and SRE might interpret or spin it:

**The Original: "Make it work, make it right, make it fast"**

*   **Make it work:** Get the basic functionality operational. Prove the concept.
*   **Make it right:** Refactor, ensure correctness, improve design, add tests, make it maintainable.
*   **Make it fast:** Optimize for performance and efficiency.

This phrase, as is, aligns quite well with general agile software development, which **DevOps heavily leverages and builds upon.** DevOps aims to do all three of these things *continuously and rapidly* through its practices (CI/CD, automation, collaboration). The "fast" in a DevOps context also strongly implies fast delivery cycles.

**DevOps Focus/Spin:**

DevOps wouldn't necessarily *change* the core phrase as much as *emphasize the process and lifecycle around it*. A DevOps interpretation might implicitly add:

*   "...and **automate its delivery**."
*   "...and **get feedback quickly**."
*   "...and **ensure shared responsibility** for all three."

So, for DevOps, it's about enabling teams to go through "work, right, fast" cycles very quickly and reliably for every feature or change. The "fast" is as much about the *delivery pipeline* and iteration speed as it is about application performance.

**SRE Focus/Spin:**

SRE (Site Reliability Engineering) has a very strong focus on reliability, scalability, and operational excellence. An SRE spin would likely re-prioritize or re-interpret the terms:

A strong SRE spin could be:

1.  **"Make it reliable."**
    *   This inherently covers "make it work" (it has to work to be reliable) and a significant part of "make it right" (correctness, fault tolerance, robustness are key to reliability). It's the absolute foundation for SRE.
2.  **"Make it observable (and measurable)."**
    *   If you can't see what it's doing or measure its performance against SLOs, you can't effectively manage its reliability or make it "fast" in a meaningful way. This is a prerequisite for both "right" and "fast" from an operational standpoint.
3.  **"Make it scalable/efficient (and fast to recover)."**
    *   "Fast" for SRE often means performant under load (scalability), efficient in resource usage (cost/capacity), and critically, *fast to detect and recover* from incidents (MTTD/MTTR).

**So, an SRE-focused spin might be:**

*   **"Make it reliable, make it observable, make it scalable/efficient."**
    or
*   **"Make it work (reliably), make it right (by SLOs), make it fast (to recover/scale)."**

**Conclusion:**

*   The original "Make it work, make it right, make it fast" is a general software development principle that **DevOps adopts and aims to accelerate through its practices.**
*   An **SRE-focused spin** would more explicitly prioritize **reliability, observability, and operational characteristics** like scalability, efficiency, and fast recovery, often framing "right" in terms of meeting Service Level Objectives (SLOs).

Therefore, a spin like **"Make it reliable, make it observable, make it scalable"** is decidedly more **SRE-focused.**